# ALMA Data Reduction Script

# Calibration

thesteps = []
step_title = {0: 'Import of the ASDM',
              1: 'Fix of SYSCAL table times',
              2: 'listobs',
              3: 'A priori flagging',
              4: 'Generation and time averaging of the WVR cal table',
              5: 'Generation of the Tsys cal table',
              6: 'Generation of the antenna position cal table',
              7: 'Application of the WVR, Tsys and antpos cal tables',
              8: 'Split out science SPWs and time average',
              9: 'Listobs, clear pointing table, and save original flags',
              10: 'Initial flagging',
              11: 'Putting a model for the flux calibrator(s)',
              12: 'Save flags before bandpass cal',
              13: 'Bandpass calibration',
              14: 'Save flags before gain cal',
              15: 'Gain calibration',
              16: 'Save flags before applycal',
              17: 'Application of the bandpass and gain cal tables',
              18: 'Split out corrected column'}

if 'applyonly' not in globals(): applyonly = False
try:
  print 'List of steps to be executed ...', mysteps
  thesteps = mysteps
except:
  print 'global variable mysteps not set.'
if (thesteps==[]):
  thesteps = range(0,len(step_title))
  print 'Executing all steps: ', thesteps

# The Python variable 'mysteps' will control which steps
# are executed when you start the script using
#   execfile('scriptForCalibration.py')
# e.g. setting
#   mysteps = [2,3,4]# before starting the script will make the script execute
# only steps 2, 3, and 4
# Setting mysteps = [] will make it execute all steps.

import re

import os

if applyonly != True: es = aU.stuffForScienceDataReduction() 


if re.search('^4.2.2', casadef.casa_version) == None:
 sys.exit('ERROR: PLEASE USE THE SAME VERSION OF CASA THAT YOU USED FOR GENERATING THE SCRIPT: 4.2.2')


# CALIBRATE_AMPLI: J0510+1800
# CALIBRATE_ATMOSPHERE: HL Tau,J0431+2037,J0510+1800
# CALIBRATE_BANDPASS: J0510+1800
# CALIBRATE_FLUX: J0510+1800
# CALIBRATE_FOCUS: 
# CALIBRATE_PHASE: J0431+2037
# CALIBRATE_POINTING: J0510+1800
# OBSERVE_TARGET: HL Tau

# Using reference antenna = DV16

# Import of the ASDM
mystep = 0
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  if os.path.exists('uid___A002_X900853_Xc7f.ms') == False:
    importasdm('uid___A002_X900853_Xc7f', asis='Antenna Station Receiver Source CalAtmosphere CalWVR')
  if applyonly != True: es.fixForCSV2555('uid___A002_X900853_Xc7f.ms')

# Fix of SYSCAL table times
mystep = 1
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  from recipes.almahelpers import fixsyscaltimes
  fixsyscaltimes(vis = 'uid___A002_X900853_Xc7f.ms')

print "# A priori calibration"

# listobs
mystep = 2
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.listobs')
  listobs(vis = 'uid___A002_X900853_Xc7f.ms',
    listfile = 'uid___A002_X900853_Xc7f.ms.listobs')
  
  

# A priori flagging
mystep = 3
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  flagdata(vis = 'uid___A002_X900853_Xc7f.ms',
    mode = 'manual',
    spw = '1~23',
    autocorr = T,
    flagbackup = F)
  
  flagdata(vis = 'uid___A002_X900853_Xc7f.ms',
    mode = 'manual',
    intent = '*POINTING*,*ATMOSPHERE*',
    flagbackup = F)
  
  flagcmd(vis = 'uid___A002_X900853_Xc7f.ms',
    inpmode = 'table',
    useapplied = True,
    action = 'plot',
    plotfile = 'uid___A002_X900853_Xc7f.ms.flagcmd.png')
  
  flagcmd(vis = 'uid___A002_X900853_Xc7f.ms',
    inpmode = 'table',
    useapplied = True,
    action = 'apply')
  

# Generation and time averaging of the WVR cal table
mystep = 4
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.wvr') 
  
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.wvrgcal') 
  
  mylogfile = casalog.logfile()
  casalog.setlogfile('uid___A002_X900853_Xc7f.ms.wvrgcal')
  
  wvrgcal(vis = 'uid___A002_X900853_Xc7f.ms',
    caltable = 'uid___A002_X900853_Xc7f.ms.wvr',
    toffset = 0,
    tie = ['HL Tau,J0431+2037'],
    statsource = 'HL Tau')
  
  casalog.setlogfile(mylogfile)
  
  # This is a temporary workaround, which will be included in a future version of CASA
  
  tb.open('uid___A002_X900853_Xc7f.ms.wvr', nomodify=False)
  count = 0
  numrows = tb.nrows()
  mycparamcol = tb.getcol('CPARAM')
  for i in range(0, numrows):
      if mycparamcol[0][0][i] == (1.+0.j):
          tb.putcell('FLAG', i, [[True]])
          count += 1
  tb.close()
  del mycparamcol
  if(numrows>0):
      print 'Flagged', count, 'of', numrows, 'solutions =', 100.*count/float(numrows),'%'
  
  
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.wvr.smooth') 
  
  smoothcal(vis = 'uid___A002_X900853_Xc7f.ms',
    tablein = 'uid___A002_X900853_Xc7f.ms.wvr',
    caltable = 'uid___A002_X900853_Xc7f.ms.wvr.smooth',
    smoothtype = 'mean',
    smoothtime = 6.048)
  
  
  if applyonly != True: aU.plotWVRSolutions(caltable='uid___A002_X900853_Xc7f.ms.wvr.smooth', spw='11', antenna='DV16',
    yrange=[-199,199],subplot=22, interactive=False,
    figfile='uid___A002_X900853_Xc7f.ms.wvr.smooth.plots/uid___A002_X900853_Xc7f.ms.wvr.smooth') 
  
  #Note: If you see wraps in these plots, try changing yrange or unwrap=True 
  #Note: If all plots look strange, it may be a bad WVR on the reference antenna.
  #      To check, you can set antenna='' to show all baselines.
  

# Generation of the Tsys cal table
mystep = 5
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.tsys') 
  gencal(vis = 'uid___A002_X900853_Xc7f.ms',
    caltable = 'uid___A002_X900853_Xc7f.ms.tsys',
    caltype = 'tsys')

  flagdata(vis='uid___A002_X900853_Xc7f.ms.tsys',
           antenna='DV11,DV16')

  flagdata('uid___A002_X900853_Xc7f.ms.tsys',
           spw='9:0~3;124~127,11:0~3;124~127,13:0~3;124~127,15:0~3;124~127')
  
  if applyonly != True: aU.plotbandpass(caltable='uid___A002_X900853_Xc7f.ms.tsys', overlay='time', 
    xaxis='freq', yaxis='amp', subplot=22, buildpdf=False, interactive=False,
    showatm=True,pwv='auto',chanrange='5~123',showfdm=True, 
    field='', figfile='uid___A002_X900853_Xc7f.ms.tsys.plots.overlayTime/uid___A002_X900853_Xc7f.ms.tsys') 
  
  
  if applyonly != True: es.checkCalTable('uid___A002_X900853_Xc7f.ms.tsys', msName='uid___A002_X900853_Xc7f.ms', interactive=False) 
  

# Generation of the antenna position cal table
mystep = 6
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]


  gencal(vis = 'uid___A002_X900853_Xc7f.ms',
         caltable = 'uid___A002_X900853_Xc7f.ms.antpos',
         caltype = 'antpos',
         parameter = [-0.0007932, -0.000306, -0.000694, # DA41 on S301 change=1.097mm
                      -0.0016006, +0.001708, -0.001228, # DA43 on S306 change=2.643mm
                      -0.0001840, +0.000954, +0.000826, # DA48 on W207 change=1.275mm
                      +0.0003173, -0.001202, -0.000992, # DA49 on A029 change=1.591mm
                      -0.0000190, +0.001558, +0.001333, # DA50 on W204 change=2.051mm
                      -0.0003280, -0.002877, -0.001613, # DA52 on A035 change=3.314mm
                      -0.0000882, +0.002211, -0.000172, # DA56 on A131 change=2.219mm
                      +0.0005700, -0.000524, -0.001783, # DA60 on P404 change=1.944mm
                      -0.0004407, +0.001632, -0.000706, # DA64 on P402 change=1.832mm
                      +0.0008220, -0.001699, -0.002352, # DA65 on P401 change=3.016mm
                      +0.0010560, -0.000340, +0.002508, # DV07 on W201 change=2.742mm
                      +0.0027843, -0.006367, +0.000048, # DV10 on A024 change=6.949mm
                      -0.0004376, +0.000927, -0.000138, # DV11 on A121 change=1.034mm
                      -0.0009430, -0.005122, -0.002383, # DV13 on S303 change=5.727mm
                      -0.0007650, +0.002156, -0.000274, # DV19 on P410 change=2.304mm
                      +0.0004740, -0.001351, -0.000593, # PM02 on T702 change=1.550mm
                      -0.0004087, +0.000999, +0.000553], # PM03 on T701 change=1.213mm
          antenna = 'DA41,DA43,DA48,DA49,DA50,DA52,DA56,DA60,DA64,DA65,DV07,DV10,DV11,DV13,DV19,PM02,PM03') 



# Application of the WVR, Tsys and antpos cal tables
mystep = 7
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  
  
  from recipes.almahelpers import tsysspwmap
  tsysmap = tsysspwmap(vis = 'uid___A002_X900853_Xc7f.ms', tsystable = 'uid___A002_X900853_Xc7f.ms.tsys', tsysChanTol = 1)
  
  
  
  applycal(vis = 'uid___A002_X900853_Xc7f.ms',
    field = '0',
    spw = '11,13,15,17,19',
    gaintable = ['uid___A002_X900853_Xc7f.ms.tsys', 'uid___A002_X900853_Xc7f.ms.wvr.smooth', 'uid___A002_X900853_Xc7f.ms.antpos'],
    gainfield = ['0', '', ''],
    interp = 'linear,linear',
    spwmap = [tsysmap,[],[]],
    calwt = T,
    flagbackup = F)
  
  
  
  applycal(vis = 'uid___A002_X900853_Xc7f.ms',
    field = '1',
    spw = '11,13,15,17,19',
    gaintable = ['uid___A002_X900853_Xc7f.ms.tsys', 'uid___A002_X900853_Xc7f.ms.wvr.smooth', 'uid___A002_X900853_Xc7f.ms.antpos'],
    gainfield = ['1', '', ''],
    interp = 'linear,linear',
    spwmap = [tsysmap,[],[]],
    calwt = T,
    flagbackup = F)
  
  
  
  applycal(vis = 'uid___A002_X900853_Xc7f.ms',
    field = '2',
    spw = '11,13,15,17,19',
    gaintable = ['uid___A002_X900853_Xc7f.ms.tsys', 'uid___A002_X900853_Xc7f.ms.wvr.smooth', 'uid___A002_X900853_Xc7f.ms.antpos'],
    gainfield = ['2', '', ''],
    interp = 'linear,linear',
    spwmap = [tsysmap,[],[]],
    calwt = T,
    flagbackup = F)
  
  if applyonly != True: es.getCalWeightStats('uid___A002_X900853_Xc7f.ms') 
  

# Split out science SPWs and time average
mystep = 8
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split') 
  split(vis = 'uid___A002_X900853_Xc7f.ms',
    outputvis = 'uid___A002_X900853_Xc7f.ms.split',
    datacolumn = 'corrected',
    spw = '11,13,15,17,19',
    keepflags = T)
  
  vis='uid___A002_X900853_Xc7f.ms.split'
  fixvis(vis=vis, field='J0431+2037',
         phasecenter='J2000 04h31m03.761375 20d37m34.2649s',
         datacolumn='DATA',reuse=False,
         outputvis=vis+'.fixed')    

print "# Calibration"

# Listobs, clear pointing table, and save original flags
mystep = 9
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.listobs')
  listobs(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    listfile = 'uid___A002_X900853_Xc7f.ms.split.fixed.listobs')
  
  tb.open('uid___A002_X900853_Xc7f.ms.split.fixed/POINTING', nomodify = False)
  a = tb.rownumbers()
  tb.removerows(a)
  tb.close()
  
  if not os.path.exists('uid___A002_X900853_Xc7f.ms.split.fixed.flagversions/Original.flags'):
    flagmanager(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
      mode = 'save',
      versionname = 'Original')
  
  

# Initial flagging
mystep = 10
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  # Flagging shadowed data
  
  flagdata(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'shadow',
    flagbackup = F)
  
  # Flagging edge channels
  
  flagdata(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'manual',
    spw = '0:0~7;120~127,1:0~7;120~127,2:0~7;120~127',
    flagbackup = F)

  # manual flags
  flagdata(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'manual',
    antenna='DV06,PM02,DV16',
    flagbackup = F) 
  
  flagdata(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'manual',
    timerange='06:48:37.0~06:48:43.2',
    flagbackup = F)  

# Putting a model for the flux calibrator(s)
mystep = 11
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  
  setjy('uid___A002_X900853_Xc7f.ms.split.fixed',
        standard='manual', field='J0510+1800', spix=-0.4295,
        reffreq='94.429570GHz', fluxdensity=[1.331820,0,0,0])

        
  

# Save flags before bandpass cal
mystep = 12
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  
  flagmanager(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'save',
    versionname = 'BeforeBandpassCalibration')
  

# Bandpass calibration
mystep = 13
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.ap_pre_bandpass') 
  
  gaincal(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.ap_pre_bandpass',
    field = '0', # J0510+1800
    spw = '0:51~76,1:51~76,2:51~76,3:768~1152,4:768~1152',
    solint = 'int',
    refant = 'DV04',
    calmode = 'p')
  
  if applyonly != True: es.checkCalTable('uid___A002_X900853_Xc7f.ms.split.fixed.ap_pre_bandpass', msName='uid___A002_X900853_Xc7f.ms.split.fixed', interactive=False) 
  
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.bandpass') 
  bandpass(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.bandpass',
    field = '0', # J0510+1800
    solint = 'inf,4.883e5Hz',scan='3,5',
    combine = 'scan',
    refant = 'DV04',
    solnorm = True,
    bandtype = 'B',
    gaintable = 'uid___A002_X900853_Xc7f.ms.split.fixed.ap_pre_bandpass')
  
  if applyonly != True: es.checkCalTable('uid___A002_X900853_Xc7f.ms.split.fixed.bandpass', msName='uid___A002_X900853_Xc7f.ms.split.fixed', interactive=False) 
  

# Save flags before gain cal
mystep = 14
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  
  flagmanager(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'save',
    versionname = 'BeforeGainCalibration')
  
  

# Gain calibration
mystep = 15
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.phase_int') 
  gaincal(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.phase_int',
    field = '0~1', # J0510+1800,J0431+2037
    solint = 'int',
    refant = 'DV04',
    gaintype = 'G',
    calmode = 'p',
    gaintable = 'uid___A002_X900853_Xc7f.ms.split.fixed.bandpass')
  
  if applyonly != True: es.checkCalTable('uid___A002_X900853_Xc7f.ms.split.fixed.phase_int', msName='uid___A002_X900853_Xc7f.ms.split.fixed', interactive=False) 
  
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.ampli_inf') 
  gaincal(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.ampli_inf',
    field = '0~1', # J0510+1800,J0431+2037
    solint = 'inf',
    refant = 'DV04',
    gaintype = 'T',
    calmode = 'a',
    gaintable = ['uid___A002_X900853_Xc7f.ms.split.fixed.bandpass', 'uid___A002_X900853_Xc7f.ms.split.fixed.phase_int'])
  
  if applyonly != True: es.checkCalTable('uid___A002_X900853_Xc7f.ms.split.fixed.ampli_inf', msName='uid___A002_X900853_Xc7f.ms.split.fixed', interactive=False) 
  
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.flux_inf') 
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.fluxscale') 
  mylogfile = casalog.logfile()
  casalog.setlogfile('uid___A002_X900853_Xc7f.ms.split.fixed.fluxscale')
  
  fluxscaleDict = fluxscale(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.ampli_inf',
    fluxtable = 'uid___A002_X900853_Xc7f.ms.split.fixed.flux_inf',
    reference = '0') # J0510+1800
  
  casalog.setlogfile(mylogfile)
  
  if applyonly != True: es.fluxscale2(caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.ampli_inf', removeOutliers=True, msName='uid___A002_X900853_Xc7f.ms', writeToFile=True, preavg=10000)
  
  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.phase_inf') 
  gaincal(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    caltable = 'uid___A002_X900853_Xc7f.ms.split.fixed.phase_inf',
    field = '0~1', # J0510+1800,J0431+2037
    solint = 'inf',
    refant = 'DV04',
    gaintype = 'G',
    calmode = 'p',
    gaintable = 'uid___A002_X900853_Xc7f.ms.split.fixed.bandpass')
  
  if applyonly != True: es.checkCalTable('uid___A002_X900853_Xc7f.ms.split.fixed.phase_inf', msName='uid___A002_X900853_Xc7f.ms.split.fixed', interactive=False) 
  

# Save flags before applycal
mystep = 16
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  
  flagmanager(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    mode = 'save',
    versionname = 'BeforeApplycal')
  
  

# Application of the bandpass and gain cal tables
mystep = 17
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  for i in ['0']: # J0510+1800
    applycal(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
      field = str(i),
      gaintable = ['uid___A002_X900853_Xc7f.ms.split.fixed.bandpass', 'uid___A002_X900853_Xc7f.ms.split.fixed.phase_int', 'uid___A002_X900853_Xc7f.ms.split.fixed.flux_inf'],
      gainfield = ['', i, i],
      interp = 'linear,linear',
      calwt = F,
      flagbackup = F)
  
  applycal(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    field = '1,2', # HL Tau
    gaintable = ['uid___A002_X900853_Xc7f.ms.split.fixed.bandpass', 'uid___A002_X900853_Xc7f.ms.split.fixed.phase_inf', 'uid___A002_X900853_Xc7f.ms.split.fixed.flux_inf'],
    gainfield = ['', '1', '1'], # J0431+2037
    interp = 'linear,linear',
    calwt = F,
    flagbackup = F)
  

# Split out corrected column
mystep = 18
if(mystep in thesteps):
  casalog.post('Step '+str(mystep)+' '+step_title[mystep],'INFO')
  print 'Step ', mystep, step_title[mystep]

  os.system('rm -rf uid___A002_X900853_Xc7f.ms.split.fixed.cal') 
  split(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    outputvis = 'uid___A002_X900853_Xc7f.ms.split.fixed.cal',
    datacolumn = 'corrected',
    keepflags = T)
  
  

  os.system('rm -rf HLTau_Xc7f.ms.split.fixed.cal') 
  split(vis = 'uid___A002_X900853_Xc7f.ms.split.fixed',
    outputvis = 'HLTau_Xc7f.ms.split.fixed.cal',
    datacolumn = 'corrected',field='2',
    keepflags = T)
